/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.mapping;

import filenet.vw.toolkit.design.visio.model.Shape;

class VWBoundingRectangle {
    private double m_minX = 0.0;
    private double m_minY = 0.0;
    private double m_maxX = 0.0;
    private double m_maxY = 0.0;

    protected VWBoundingRectangle(Shape shape) {
        this.calculateBounds(shape);
    }

    protected boolean contains(Shape shape) {
        boolean bContains = false;
        if (shape != null) {
            bContains = shape.getPinX() > this.m_minX && shape.getPinX() < this.m_maxX && shape.getPinY() > this.m_minY && shape.getPinY() < this.m_maxY;
        }
        return bContains;
    }

    protected boolean contains(VWBoundingRectangle boundingRect) {
        double rectHeight;
        double rectWidth;
        double myHeight;
        double myWidth = this.getWidth();
        if (myWidth < 0.0 | (myHeight = this.getHeight()) < 0.0 | (rectWidth = boundingRect.getWidth()) < 0.0 | (rectHeight = boundingRect.getHeight()) < 0.0) {
            return false;
        }
        double myX = this.getX();
        double myY = this.getY();
        double rectX = boundingRect.getX();
        double rectY = boundingRect.getY();
        if (rectX < myX || rectY < myY) {
            return false;
        }
        myWidth += myX;
        if ((rectWidth += rectX) <= rectX ? myWidth >= myX || rectWidth > myWidth : myWidth >= myX && rectWidth > myWidth) {
            return false;
        }
        myHeight += myY;
        return !((rectHeight += rectY) <= rectY ? myHeight >= myY || rectHeight > myHeight : myHeight >= myY && rectHeight > myHeight);
    }

    protected double getX() {
        return this.m_minX;
    }

    protected double getY() {
        return this.m_minY;
    }

    protected double getWidth() {
        return this.m_maxX - this.m_minX;
    }

    protected double getHeight() {
        return this.m_maxY - this.m_minY;
    }

    private void calculateBounds(Shape shape) {
        if (shape != null) {
            switch ((int)Math.toDegrees(shape.getAngle())) {
                case -90: 
                case 90: {
                    this.m_minX = shape.getPinX() - shape.getLocPinY();
                    this.m_maxY = shape.getPinY() + shape.getLocPinX();
                    this.m_maxX = this.m_minX + shape.getHeight();
                    this.m_minY = this.m_maxY - shape.getWidth();
                    break;
                }
                case 0: 
                case 180: {
                    this.m_minX = shape.getPinX() - shape.getLocPinX();
                    this.m_maxY = shape.getPinY() + shape.getLocPinY();
                    this.m_maxX = this.m_minX + shape.getWidth();
                    this.m_minY = this.m_maxY - shape.getHeight();
                    break;
                }
                default: {
                    this.m_minX = shape.getPinX() - shape.getLocPinX();
                    this.m_maxY = shape.getPinY() + shape.getLocPinY();
                    this.m_maxX = this.m_minX + shape.getWidth();
                    this.m_minY = this.m_maxY - shape.getHeight();
                    double tmpMinX = this.m_minX - shape.getPinX();
                    double tmpMaxY = this.m_maxY - shape.getPinY();
                    double tmpMaxX = this.m_maxX - shape.getPinX();
                    double tmpMinY = this.m_minY - shape.getPinY();
                    double sinValue = Math.sin(shape.getAngle());
                    double cosValue = Math.cos(shape.getAngle());
                    this.m_minX = tmpMinX * cosValue - tmpMaxY * sinValue;
                    this.m_maxY = tmpMaxX * sinValue + tmpMaxY * cosValue;
                    this.m_maxX = tmpMaxX * cosValue - tmpMinY * sinValue;
                    this.m_minY = tmpMinX * sinValue + tmpMinY * cosValue;
                    this.m_minX += shape.getPinX();
                    this.m_maxY += shape.getPinY();
                    this.m_maxX += shape.getPinX();
                    this.m_minY += shape.getPinY();
                }
            }
        }
    }

    public void grow(double nHoriz, double nVert) {
        this.m_minX -= nHoriz;
        this.m_minY -= nVert;
        this.m_maxX += nHoriz;
        this.m_maxY += nVert;
    }
}

